
cap program drop polsnow
program define polsnow
gen n_pols_pres=n_pols_pres_c+n_pols_pres_p+n_pols_pres_r+n_pols_pres_n
gen n_pols_exe=n_pols_exe_c+n_pols_exe_p+n_pols_exe_r+n_pols_exe_n
gen n_pols_cou=n_pols_cou_c+n_pols_cou_p+n_pols_cou_r+n_pols_cou_n
end

cap program drop preparenow
program define preparenow
use if year!=2012 using "${dir3}INPS_temp_noPA.dta", clear
drop CF2  

sort id year
bysort id: gen entry=empl[_n-1]==0 & empl==1 if empl[_n-1]!=. & empl!=.
replace entry=empl if year==1989
bysort id: replace entry=entry[_n-1]+entry if entry[_n-1]!=.
sort id year
bysort id: gen exit=empl==0 & empl[_n-1]==1 if empl[_n-1]!=. & empl!=.
replace exit=empl if year==1989
bysort id: replace exit=exit[_n-1]+exit if exit[_n-1]!=.

drop if $geo==.

g empl=n_paid_m>0
bysort id: egen sum_empl=sum(empl)
drop if sum_empl==0
egen sum_tot_wg=sum(tot_wg), by(id)
drop if sum_tot_wg==0
drop sum_empl sum_tot_wg

drop if id==.

gen aged=.
forvalues j=1(1)6 {
replace aged=`j' if age>=16+10*(`j'-1) & age<16+10*(`j')
}

cap drop _m
merge m:1 $CF1 r_bth_i p_bth_i c_bth_i year using "${dir1}/${polfile}", keep(master matched) keepusing(/*
*/ n_pols n_pols_c n_pols_p n_pols_r n_pols_n /*
*/ n_pols_top n_pols_cou n_pols_cens_85  /*
*/ n_pols_ing n_pols_ing_p_c n_pols_ing_p_p n_pols_ing_p_r n_pols_ing_p_n n_pols_ing_p_ten_c_t_01 n_pols_ing_p_ten_c_t_12 n_pols_ing_p_ten_c_t_gt2 n_pols_ing2_p_ten_c_t_01 n_pols_ing2_p_ten_c_t_12 n_pols_ing2_p_ten_c_t_gt2 /*
*/ n_pols_ing_p_old n_pols_ing_p_mid n_pols_ing_p_young /*
*/ n_pols_ing_p_fem n_pols_ing_p_fem_old n_pols_ing_p_fem_mid n_pols_ing_p_fem_young n_pols_ing_p_mal_old n_pols_ing_p_mal_mid n_pols_ing_p_mal_young /*
*/ n_pols_ing_p_top n_pols_ing_p_cou n_pols_ing2_p_top n_pols_ing2_p_cou /*
*/ n_pols_out n_pols_out_p_c n_pols_out_p_p n_pols_out_p_r n_pols_out_p_n n_pols_out_p_ten_c_t_01 n_pols_out_p_ten_c_t_12 n_pols_out_p_ten_c_t_gt2 n_pols_out2_p_ten_c_t_01 n_pols_out2_p_ten_c_t_12 n_pols_out2_p_ten_c_t_gt2 /*
*/ n_pols_out_p_old n_pols_out_p_mid n_pols_out_p_young /*
*/ n_pols_out_p_fem n_pols_out_p_fem_old n_pols_out_p_fem_mid n_pols_out_p_fem_young n_pols_out_p_mal_old n_pols_out_p_mal_mid n_pols_out_p_mal_young /*
*/ n_pols_out_p_top n_pols_out_p_cou n_pols_out2_p_top n_pols_out2_p_cou /*
*/)
g n_pols_ing_p_mal=n_pols_ing-n_pols_ing_p_fem
g n_pols_out_p_mal=n_pols_out-n_pols_out_p_fem

for any n_pols n_pols_c n_pols_p n_pols_r n_pols_n /*
*/ n_pols_top n_pols_cou n_pols_cens_85  /*
*/ n_pols_ing n_pols_ing_p_c n_pols_ing_p_p n_pols_ing_p_r n_pols_ing_p_n n_pols_ing_p_ten_c_t_01 n_pols_ing_p_ten_c_t_12 n_pols_ing_p_ten_c_t_gt2 n_pols_ing2_p_ten_c_t_01 n_pols_ing2_p_ten_c_t_12 n_pols_ing2_p_ten_c_t_gt2 /*
*/ n_pols_ing_p_old n_pols_ing_p_mid n_pols_ing_p_young /*
*/ n_pols_ing_p_fem n_pols_ing_p_mal n_pols_ing_p_fem_old n_pols_ing_p_fem_mid n_pols_ing_p_fem_young n_pols_ing_p_mal_old n_pols_ing_p_mal_mid n_pols_ing_p_mal_young /*
*/ n_pols_ing_p_top n_pols_ing_p_cou n_pols_ing2_p_top n_pols_ing2_p_cou /*
*/ n_pols_out n_pols_out_p_c n_pols_out_p_p n_pols_out_p_r n_pols_out_p_n n_pols_out_p_ten_c_t_01 n_pols_out_p_ten_c_t_12 n_pols_out_p_ten_c_t_gt2 n_pols_out2_p_ten_c_t_01 n_pols_out2_p_ten_c_t_12 n_pols_out2_p_ten_c_t_gt2 /*
*/ n_pols_out_p_old n_pols_out_p_mid n_pols_out_p_young /*
*/ n_pols_out_p_fem n_pols_out_p_mal n_pols_out_p_fem_old n_pols_out_p_fem_mid n_pols_out_p_fem_young n_pols_out_p_mal_old n_pols_out_p_mal_mid n_pols_out_p_mal_young /*
*/ n_pols_out_p_top n_pols_out_p_cou n_pols_out2_p_top n_pols_out2_p_cou /*
*/ : replace X=0 if _m==1

for any n_pols_ing n_pols_ing_p_c n_pols_ing_p_p n_pols_ing_p_r n_pols_ing_p_n n_pols_ing_p_ten_c_t_01 n_pols_ing_p_ten_c_t_12 n_pols_ing_p_ten_c_t_gt2 n_pols_ing2_p_ten_c_t_01 n_pols_ing2_p_ten_c_t_12 n_pols_ing2_p_ten_c_t_gt2 /*
*/ n_pols_ing_p_old n_pols_ing_p_mid n_pols_ing_p_young /*
*/ n_pols_ing_p_fem n_pols_ing_p_mal n_pols_ing_p_fem_old n_pols_ing_p_fem_mid n_pols_ing_p_fem_young n_pols_ing_p_mal_old n_pols_ing_p_mal_mid n_pols_ing_p_mal_young /*
*/ n_pols_ing_p_top n_pols_ing_p_cou n_pols_ing2_p_top n_pols_ing2_p_cou /*
*/ n_pols_out n_pols_out_p_c n_pols_out_p_p n_pols_out_p_r n_pols_out_p_n n_pols_out_p_ten_c_t_01 n_pols_out_p_ten_c_t_12 n_pols_out_p_ten_c_t_gt2 n_pols_out2_p_ten_c_t_01 n_pols_out2_p_ten_c_t_12 n_pols_out2_p_ten_c_t_gt2 /*
*/ n_pols_out_p_old n_pols_out_p_mid n_pols_out_p_young /*
*/ n_pols_out_p_fem n_pols_out_p_mal n_pols_out_p_fem_old n_pols_out_p_fem_mid n_pols_out_p_fem_young n_pols_out_p_mal_old n_pols_out_p_mal_mid n_pols_out_p_mal_young /*
*/ n_pols_out_p_top n_pols_out_p_cou n_pols_out2_p_top n_pols_out2_p_cou /*
*/ : replace X=. if year==1985

drop _merge

label var n_paid_m "Tot months"
label var n_paid_d "Tot days"
label var n_paid_w "Tot weeks"
label var tot_wg "Tot earnings"
label var n_pols "Politicians"

egen max_n_pols=max(n_pols), by(CF1 p_b r_b c_b) 

cap drop _m
rename c_bth_i codice_comune_istat_num103
merge m:1 codice_comune_istat_num103 using "${dir1}DEMO_cat.dta",keep(master matched) keepusing(c_prov_capital c_reg_capital c_pop)
rename codice_comune_istat_num103 c_bth_i 
cap drop _m
polsnow

egen cf1=group($CF1)
egen gr3=group(c_b cf1)

end

** Main file

global geo="c_b"
global CF1="CF1"
global polfile="POL19852011_cat_CF1.dta"
preparenow

cap drop _m
rename c_bth_i codice_comune_istat_num103
for any p r: rename X_b X_i
cap drop _m

gen distretto=""
replace distretto="ANCONA" if r_b==11
replace distretto="BARI" if r_b==16 & p_b!=73 & p_b!=75
replace distretto="LECCE" if p_b==73 | p_b==75
replace distretto="BOLOGNA" if r_b==8
replace distretto="MILANO" if r_b==3 & p_b!=16 & p_b!=17 & p_b!=19 & p_b!=20
replace distretto="BRESCIA" if p_b==16 | p_b==17 | p_b==19 | p_b==20
replace distretto="CAGLIARI" if r_b==20
replace distretto="PALERMO" if r_b==19 & p_b!=83 & p_b!=85 & p_b!=86 & p_b!=87 & p_b!=88 & p_b!=89
replace distretto="CALTANISSETTA" if p_b==85 | p_b==86
replace distretto="CATANIA" if p_b==87 | p_b==88 | p_b==89
replace distretto="MESSINA" if p_b==83
replace distretto="CAMPOBASSO" if r_b==14
replace distretto="ROMA" if r_b==12
replace distretto="CATANZARO" if r_b==18 & p_b!=80
replace distretto="REGGIO DI CALABRIA" if p_b==80
replace distretto="FIRENZE" if r_b==9
replace distretto="GENOVA" if r_b==7
replace distretto="L'AQUILA" if r_b==13
replace distretto="NAPOLI" if r_b==15 & p_b!=65
replace distretto="SALERNO" if p_b==65
replace distretto="PERUGIA" if r_b==10
replace distretto="POTENZA" if r_b==17
replace distretto="TORINO" if r_b==1 | r_b==2
replace distretto="TRENTO" if r_b==4
replace distretto="TRIESTE" if r_b==6
replace distretto="VENEZIA" if r_b==5
egen newd=group(distretto)

compress
saveold "${dir3}/merged${CF1}_noPA.dta", replace



